/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.UserProperties;
import com.ibm.hwmca.fw.managed.UserRole;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.settings.user.DefaultUserSettings;
import com.ibm.hwmca.fw.settings.user.UIStyleSettings;
import com.ibm.hwmca.fw.settings.user.UserSettings;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.system.InvalidPasswordException;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIStyle;
import com.ibm.hwmca.fw.ui.UIStyleManager;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class User
extends HwmcaObject
implements UserProperties {
    private byte[] password;
    private boolean caseSensitive = false;
    private boolean disabled = false;
    private HashSet userRoles;
    HashMap userSettings;
    private Object userRoleMonitor = new Object();
    private boolean displayable = true;
    private boolean editable = false;
    private boolean rulesEnforced = false;
    private int expireDays = 0;
    private int sessionTimeOut = 0;
    private int verifyTimeOut = 15;
    private int idleTimeOut = 0;
    private long expireStartDate = 0L;
    private static String userClass;
    private static boolean allowMultipleRoles;
    private Object settingsMonitor = new Object();
    private static final ClassId[] USER_CLASSID_ARRAY;
    private static final ClassId[] HWMCA_OBJECT_CLASSID_ARRAY;
    private boolean remoteAccess = false;
    private static final FrameworkClassLogInfo logInfo;
    private static final String TRACE_MASKT = "XFRMUSRT";
    private static final String TRACE_MASKF = "XFRMUSRF";
    private static final String TRACE_MASKD = "XFRMUSRD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$User;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$HwmcaObject;

    public User(String userName, String password, UIInfo uiInfo) {
        if (this.getClass().equals(class$com$ibm$hwmca$fw$managed$User == null ? (class$com$ibm$hwmca$fw$managed$User = User.class$("com.ibm.hwmca.fw.managed.User")) : class$com$ibm$hwmca$fw$managed$User)) {
            Trace.trace(TRACE_MASKT, "<> User(userName=" + userName + ")");
        }
        this.userRoles = new HashSet();
        ObjectId objectId = new ObjectId(this);
        objectId.setKeyProperty("UserName", userName);
        this.setObjectId(objectId);
        this.setPassword(password);
        this.uiInfo = uiInfo;
        this.persistent = true;
    }

    public User(PersistentData data, String persistKey) {
        super(((Persistent)data).parentData, persistKey);
        int i;
        if (this.getClass().equals(class$com$ibm$hwmca$fw$managed$User == null ? (class$com$ibm$hwmca$fw$managed$User = User.class$("com.ibm.hwmca.fw.managed.User")) : class$com$ibm$hwmca$fw$managed$User)) {
            Trace.trace(TRACE_MASKT, "<> User(data=" + data + ", persistKey=" + persistKey + ")");
        }
        this.password = ((Persistent)data).password;
        this.caseSensitive = ((Persistent)data).caseSensitive;
        this.disabled = ((Persistent)data).disabled;
        this.displayable = ((Persistent)data).displayable;
        this.editable = ((Persistent)data).editable;
        this.rulesEnforced = ((Persistent)data).rulesEnforced;
        this.expireDays = ((Persistent)data).expireDays;
        this.sessionTimeOut = ((Persistent)data).sessionTimeOut;
        this.verifyTimeOut = ((Persistent)data).verifyTimeOut;
        this.idleTimeOut = ((Persistent)data).idleTimeOut;
        this.expireStartDate = ((Persistent)data).expireStartDate;
        this.userRoles = new HashSet();
        this.remoteAccess = ((Persistent)data).remoteAccess;
        for (i = 0; i < ((Persistent)data).userRoles.length; ++i) {
            try {
                UserRole role = (UserRole)mom.get(((Persistent)data).userRoles[i]);
                if (role == null) continue;
                this.userRoles.add(role);
                continue;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception getting UserRole object from MOM: " + e);
                Trace.trace(TRACE_MASKF, e);
            }
        }
        if (((Persistent)data).userSettings != null) {
            this.userSettings = new HashMap();
            for (i = 0; i < ((Persistent)data).userSettings.length; ++i) {
                this.userSettings.put(((Persistent)data).userSettings[i].getClass().getName(), ((Persistent)data).userSettings[i]);
            }
        }
    }

    public void updatePersistedUser(PersistentData data, String persistKey, User user) {
        if (this.getClass().equals(class$com$ibm$hwmca$fw$managed$User == null ? (class$com$ibm$hwmca$fw$managed$User = User.class$("com.ibm.hwmca.fw.managed.User")) : class$com$ibm$hwmca$fw$managed$User)) {
            Trace.trace(TRACE_MASKT, "--> User.updatePersistedUser() " + user.getUIInfo().getName());
        }
        user.password = ((Persistent)data).password;
        user.caseSensitive = ((Persistent)data).caseSensitive;
        user.disabled = ((Persistent)data).disabled;
        user.displayable = ((Persistent)data).displayable;
        user.editable = ((Persistent)data).editable;
        user.rulesEnforced = ((Persistent)data).rulesEnforced;
        user.expireDays = ((Persistent)data).expireDays;
        user.sessionTimeOut = ((Persistent)data).sessionTimeOut;
        user.verifyTimeOut = ((Persistent)data).verifyTimeOut;
        user.idleTimeOut = ((Persistent)data).idleTimeOut;
        user.expireStartDate = ((Persistent)data).expireStartDate;
        user.remoteAccess = ((Persistent)data).remoteAccess;
        this.userRoles = this.getPermittedRoles(((Persistent)data).userRoles);
        user.addUserRoles(this.userRoles);
        if (((Persistent)data).userSettings != null) {
            this.userSettings = new HashMap();
            for (int i = 0; i < ((Persistent)data).userSettings.length; ++i) {
                this.userSettings.put(((Persistent)data).userSettings[i].getClass().getName(), ((Persistent)data).userSettings[i]);
            }
        }
        if (this.getClass().equals(class$com$ibm$hwmca$fw$managed$User == null ? (class$com$ibm$hwmca$fw$managed$User = User.class$("com.ibm.hwmca.fw.managed.User")) : class$com$ibm$hwmca$fw$managed$User)) {
            Trace.trace(TRACE_MASKT, "<-- User.updatePersistedUser()");
        }
    }

    public String getUserName() {
        return (String)this.getObjectId().getKeyProperty("UserName");
    }

    public static User getUser() {
        User result = null;
        UserContext userContext = UserContext.getCurrentUserContext();
        if (userContext != null && userContext.isAuthenticated()) {
            result = User.getUser(userContext.getUserid());
        }
        return result;
    }

    public static User getUser(String userid) {
        Trace.trace(TRACE_MASKT, "-> getUser(userid=" + userid + ")");
        User result = null;
        Set inventory = mom.getInventoryObjects(USER_CLASSID_ARRAY);
        Iterator iterator = inventory.iterator();
        while (iterator.hasNext() && result == null) {
            User user = (User)iterator.next();
            String userName = user.getUserName();
            boolean caseSensitive = user.isCaseSensitive();
            if ((userName == null || !caseSensitive || !userName.equals(userid)) && (caseSensitive || !userName.equalsIgnoreCase(userid))) continue;
            result = user;
        }
        Trace.trace(TRACE_MASKT, "<- getUser(returns " + result + ")");
        return result;
    }

    public static User getUser(String userid, UserContext context) {
        return User.getUser(userid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserRole(UserRole userRole) {
        Trace.trace(TRACE_MASKT, "-> addUserRole(userRole=" + userRole + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object object2 = this.userRoleMonitor;
            synchronized (object2) {
                this.userRoles.add(userRole);
            }
            this.fireContainerPropertyAdd("UserRoles", userRole.getObjectId());
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- addUserRole()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserRoles(Collection userRoles) {
        Trace.trace(TRACE_MASKT, "-> addUserRoles(userRoles=" + userRoles + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object object2 = this.userRoleMonitor;
            synchronized (object2) {
                this.userRoles.addAll(userRoles);
            }
            UserRole[] userRoleArray = new UserRole[userRoles.size()];
            userRoles.toArray(userRoleArray);
            ObjectId[] idArray = new ObjectId[userRoleArray.length];
            for (int ix = 0; ix < userRoleArray.length; ++ix) {
                idArray[ix] = userRoleArray[ix].getObjectId();
            }
            this.fireContainerPropertyAdd("UserRoles", idArray);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- addUserRole()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUserRole(UserRole userRole) {
        boolean removed;
        Trace.trace(TRACE_MASKT, "-> removeUserRole(userRole=" + userRole + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object object2 = this.userRoleMonitor;
            synchronized (object2) {
                removed = this.userRoles.remove(userRole);
            }
            if (removed) {
                this.fireContainerPropertyRemove("UserRoles", userRole.getObjectId());
            }
        }
        if (removed) {
            this.autoPersist();
        }
        Trace.trace(TRACE_MASKT, "<- removeUserRole(returns " + removed + ")");
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUserRoles(Collection userRoles) {
        boolean removed;
        Trace.trace(TRACE_MASKT, "-> removeUserRoles(userRoles=" + userRoles + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            HashSet oldSet = (HashSet)this.userRoles.clone();
            Object object2 = this.userRoleMonitor;
            synchronized (object2) {
                removed = this.userRoles.removeAll(userRoles);
                if (removed) {
                    oldSet.removeAll(this.userRoles);
                }
            }
            if (removed) {
                UserRole[] userRoleArray = new UserRole[oldSet.size()];
                oldSet.toArray(userRoleArray);
                ObjectId[] idArray = new ObjectId[userRoleArray.length];
                for (int ix = 0; ix < userRoleArray.length; ++ix) {
                    idArray[ix] = userRoleArray[ix].getObjectId();
                }
                this.fireContainerPropertyRemove("UserRoles", idArray);
            }
        }
        if (removed) {
            this.autoPersist();
        }
        Trace.trace(TRACE_MASKT, "<- removeUserRoles(returns " + removed + ")");
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllUserRoles() {
        Trace.trace(TRACE_MASKT, "-> removeAllUserRoles()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            UserRole[] userRoleArray;
            Object object2 = this.userRoleMonitor;
            synchronized (object2) {
                userRoleArray = new UserRole[this.userRoles.size()];
                this.userRoles.toArray(userRoleArray);
                this.userRoles.clear();
            }
            ObjectId[] idArray = new ObjectId[userRoleArray.length];
            for (int ix = 0; ix < userRoleArray.length; ++ix) {
                idArray[ix] = userRoleArray[ix].getObjectId();
            }
            this.fireContainerPropertyRemove("UserRoles", idArray);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- removeAllUserRoles()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getUserRoles() {
        Object object = this.userRoleMonitor;
        synchronized (object) {
            return (Set)this.userRoles.clone();
        }
    }

    public boolean isObjectPermitted(ObjectId objectId) {
        Trace.trace(TRACE_MASKT, "-> isObjectPermitted(objectid " + objectId + ")");
        boolean result = false;
        Iterator iterator = this.getUserRoles().iterator();
        while (iterator.hasNext() && !result) {
            UserRole userRole = (UserRole)iterator.next();
            if (!userRole.isObjectPermitted(objectId)) continue;
            result = true;
        }
        Trace.trace(TRACE_MASKT, "<- isObjectPermitted(returns " + result + ")");
        return result;
    }

    public boolean isPasswordValid(String password) {
        if (!this.isCaseSensitive()) {
            password = password.toUpperCase(Locale.US);
        }
        byte[] testPassword = CommonSystem.getCommonSystem().hashPassword(password);
        boolean result = Arrays.equals(testPassword, this.password);
        Trace.trace(TRACE_MASKT, "<> isPasswordValid(returns " + result + ")");
        return result;
    }

    public void changePassword(String oldPassword, String newPassword) throws InvalidPasswordException {
        Trace.trace(TRACE_MASKT, "<> changePassword()");
        if (!this.isPasswordValid(oldPassword)) {
            throw new InvalidPasswordException("Password not set because supplied current password is invalid");
        }
        this.setPassword(newPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String password) {
        Trace.trace(TRACE_MASKT, "<> setPassword()");
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            if (!this.isCaseSensitive()) {
                password = password.toUpperCase(Locale.US);
            }
            this.password = CommonSystem.getCommonSystem().hashPassword(password);
            this.firePropertyChange("Password", null, null);
            FrameworkEventText fet = new FrameworkEventText(948);
            SystemEventLog logEvent = new SystemEventLog(fet, "USRPWCHG");
            logEvent.log();
            E4EventLog e4EventLog = new E4EventLog(fet, "USRPWCHG");
            e4EventLog.log();
        }
        this.autoPersist();
    }

    public byte[] getPassword() {
        Trace.trace(TRACE_MASKT, "<> getPassword()");
        return this.password;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        Trace.trace(TRACE_MASKT, "<> setCaseSensitive()");
        this.caseSensitive = caseSensitive;
        this.autoPersist();
    }

    public boolean isCaseSensitive() {
        Trace.trace(TRACE_MASKT, "<> isCaseSensitive()");
        return this.caseSensitive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisabled(boolean disabled) {
        Trace.trace(TRACE_MASKT, "<> setDisabled()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.disabled = disabled;
            this.firePropertyChange("Disabled", null, null);
        }
        this.autoPersist();
    }

    public boolean isDisabled() {
        Trace.trace(TRACE_MASKT, "<> isDisabled()");
        return this.disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.password = this.password;
        result.caseSensitive = this.caseSensitive;
        result.disabled = this.disabled;
        result.displayable = this.displayable;
        result.editable = this.editable;
        result.rulesEnforced = this.rulesEnforced;
        result.expireDays = this.expireDays;
        result.sessionTimeOut = this.sessionTimeOut;
        result.verifyTimeOut = this.verifyTimeOut;
        result.idleTimeOut = this.idleTimeOut;
        result.expireStartDate = this.expireStartDate;
        result.remoteAccess = this.remoteAccess;
        Object object = this.userRoleMonitor;
        synchronized (object) {
            int i;
            ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
            UserRole[] userRoleArray = new UserRole[this.userRoles.size()];
            this.userRoles.toArray(userRoleArray);
            for (i = 0; i < userRoleArray.length; ++i) {
                try {
                    if (userRoleArray[i] == null) continue;
                    ids.add(userRoleArray[i].getObjectId());
                    continue;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception getting UserRole object ID: " + e);
                    Trace.trace(TRACE_MASKF, e);
                }
            }
            result.userRoles = new ObjectId[ids.size()];
            for (i = 0; i < result.userRoles.length; ++i) {
                result.userRoles[i] = (ObjectId)ids.get(i);
            }
            if (this.userSettings != null) {
                UserSettings[] userSettingsArray = new UserSettings[this.userSettings.size()];
                result.userSettings = this.userSettings.values().toArray(userSettingsArray);
            }
        }
        return result;
    }

    public boolean isUpgradeData() {
        return true;
    }

    public UIStyle getUIStyle() {
        Trace.trace(TRACE_MASKT, "-> User.getUIStyle()");
        UIStyle result = null;
        UIStyleSettings uis = (UIStyleSettings)this.getUserSettings("com.ibm.hwmca.fw.settings.user.UIStyleSettings");
        if (uis == null) {
            Trace.trace(TRACE_MASKT, "   could not get user settings, return default ui style");
            result = UIStyleManager.getUIStyleManager().getDefaultUIStyle();
        } else {
            String id = uis.getIdentifier();
            List uiStyles = UIStyleManager.getUIStyleManager().getUIStyles();
            Iterator iterator = uiStyles.iterator();
            while (iterator.hasNext()) {
                UIStyle uiStyle = (UIStyle)iterator.next();
                if (!id.equals(uiStyle.getIdentifier())) continue;
                result = uiStyle;
                break;
            }
        }
        Trace.trace(TRACE_MASKT, "<- User.getUIStyle()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAllUserSettings() {
        Trace.trace(TRACE_MASKT, "-> getAllUserSettings()");
        Map<String, UserSettings> settings = new HashMap();
        Map defaultSettings = DefaultUserSettings.getDefaultUserSettings().getUserSettings();
        Object object = this.settingsMonitor;
        synchronized (object) {
            if (this.hasAuth("base.rolegroup.acsadmin")) {
                settings = defaultSettings;
            } else {
                Set classNames = defaultSettings.keySet();
                Iterator iterator = classNames.iterator();
                while (iterator.hasNext()) {
                    String className = (String)iterator.next();
                    UserSettings next = null;
                    if (this.userSettings != null) {
                        next = (UserSettings)this.userSettings.get(className);
                    }
                    next = next == null ? (UserSettings)((UserSettings)defaultSettings.get(className)).clone() : (UserSettings)next.clone();
                    settings.put(className, next);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- getAllUserSettings()");
        return settings;
    }

    public Map getUserSettings() {
        return this.getAllUserSettings();
    }

    public UserSettings getUserSettings(String settingsClassName) {
        Trace.trace(TRACE_MASKT, "<> getUserSettings(settingsClassName=" + settingsClassName + ")");
        UserSettings result = (UserSettings)this.getAllUserSettings().get(settingsClassName);
        if (result != null) {
            result = (UserSettings)result.clone();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserSettings(UserSettings setting) {
        Trace.trace(TRACE_MASKT, "-> setUserSettings(setting=" + setting + ")");
        boolean persist = false;
        UserSettings newSetting = (UserSettings)setting.clone();
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            UserSettings oldValue = null;
            Object object2 = this.settingsMonitor;
            synchronized (object2) {
                String key = newSetting.getClass().getName();
                if (this.hasAuth("base.rolegroup.acsadmin")) {
                    DefaultUserSettings defaultSettings = DefaultUserSettings.getDefaultUserSettings();
                    oldValue = defaultSettings.getUserSettings(key);
                    defaultSettings.replace(newSetting);
                } else {
                    if (this.userSettings == null) {
                        this.userSettings = new HashMap();
                    }
                    oldValue = (UserSettings)this.getAllUserSettings().get(key);
                    this.userSettings.put(key, newSetting);
                    persist = true;
                }
            }
            this.firePropertyChange("UserSettings", oldValue, newSetting);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- setUserSettings()");
    }

    public Set getPermittedInventory() {
        Object result = null;
        Set inventory = null;
        UserContext userContext = UserContext.getCurrentUserContext();
        if (userContext != null && userContext.isAuthenticated()) {
            inventory = this.hasAuth("base.rolegroup.acsadmin") || this.hasAuth("base.rolegroup.pedebug") ? mom.getInventoryObjects() : mom.getInventory(HWMCA_OBJECT_CLASSID_ARRAY);
        }
        return inventory;
    }

    public boolean isDisplayable() {
        return this.displayable;
    }

    public void setDisplayable(boolean displayFlag) {
        this.displayable = displayFlag;
        this.autoPersist();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editFlag) {
        this.editable = editFlag;
        this.autoPersist();
    }

    public boolean hasAuth(String validString) {
        Set myRoles = this.getUserRoles();
        Iterator iteratorx = myRoles.iterator();
        while (iteratorx.hasNext()) {
            UserRole curRole = (UserRole)iteratorx.next();
            if (!curRole.getName().equals(validString)) continue;
            return true;
        }
        return false;
    }

    public boolean isPasswordRulesEnforced() {
        return this.rulesEnforced;
    }

    public void setPasswordRulesEnforced(boolean enforceFlag) {
        this.rulesEnforced = enforceFlag;
        this.autoPersist();
    }

    public void setPasswordExpiration(int expireDays) {
        this.expireDays = expireDays;
        this.autoPersist();
    }

    public int getPasswordExpiration() {
        return this.expireDays;
    }

    public void setSessionTimeOut(int sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
        this.autoPersist();
    }

    public int getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    public void setVerifyTimeOut(int verifyTimeOut) {
        this.verifyTimeOut = verifyTimeOut;
        this.autoPersist();
    }

    public int getVerifyTimeOut() {
        return this.verifyTimeOut;
    }

    public void setIdleTimeOut(int idleTimeOut) {
        this.idleTimeOut = idleTimeOut;
        this.autoPersist();
    }

    public int getIdleTimeOut() {
        return this.idleTimeOut;
    }

    public void setExpirationStartDate(long expireStartDate) {
        this.expireStartDate = expireStartDate;
        this.autoPersist();
    }

    public long getExpirationStartDate() {
        if (this.expireDays > 0) {
            return this.expireStartDate;
        }
        return 0L;
    }

    public boolean isRemoteAccessPermitted() {
        return this.remoteAccess;
    }

    public void setRemoteAccess(boolean access) {
        this.remoteAccess = access;
        this.autoPersist();
    }

    public static boolean isUserPedebug(String userid) {
        boolean result = false;
        if (User.getUser(userid).hasAuth("base.rolegroup.pedebug")) {
            result = true;
        }
        return result;
    }

    private HashSet getPermittedRoles(ObjectId[] data) {
        Trace.trace(TRACE_MASKT, "-> getPermittedRoles data length is  " + data.length);
        HashSet<UserRole> currentRoles = new HashSet<UserRole>();
        for (int i = 0; i < data.length; ++i) {
            try {
                UserRole role = (UserRole)mom.get(data[i]);
                if (role == null) continue;
                currentRoles.add(role);
                continue;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception getting UserRole object from MOM: " + e);
                Trace.trace(TRACE_MASKF, e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- getPermittedRoles ");
        return currentRoles;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        USER_CLASSID_ARRAY = new ClassId[]{new ClassId(class$com$ibm$hwmca$fw$managed$User == null ? (class$com$ibm$hwmca$fw$managed$User = User.class$("com.ibm.hwmca.fw.managed.User")) : class$com$ibm$hwmca$fw$managed$User)};
        HWMCA_OBJECT_CLASSID_ARRAY = new ClassId[]{new ClassId(class$com$ibm$hwmca$fw$managed$HwmcaObject == null ? (class$com$ibm$hwmca$fw$managed$HwmcaObject = User.class$("com.ibm.hwmca.fw.managed.HwmcaObject")) : class$com$ibm$hwmca$fw$managed$HwmcaObject)};
        logInfo = new FrameworkClassLogInfo(85, "User");
    }

    private static class Persistent
    implements PersistentData {
        int version = 0;
        PersistentData parentData;
        byte[] password;
        boolean caseSensitive;
        boolean disabled;
        boolean displayable;
        boolean editable;
        boolean rulesEnforced;
        int expireDays;
        int sessionTimeOut;
        int verifyTimeOut;
        int idleTimeOut;
        long expireStartDate;
        ObjectId[] userRoles;
        UserSettings[] userSettings;
        private static final long serialVersionUID = 4103056583246736043L;
        boolean remoteAccess;

        private Persistent() {
        }
    }
}

